%------------------------------------------------------------------------------
% File     : COM200^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Computing Theory
% Problem  : Koenig's lemma (about infinite trees) 111
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [BH+14] Blanchette et al. (2014), Truly Modular (Co)datatypes
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : koenig__111.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v7.1.0
% Syntax   : Number of formulae    :  346 (  65 unt;  51 typ;   0 def)
%            Number of atoms       :  854 ( 448 equ;   0 cnn)
%            Maximal formula atoms :    9 (   2 avg)
%            Number of connectives : 3456 (  80   ~;  21   |;  19   &;2960   @)
%                                         (   0 <=>; 376  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   15 (   6 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :   80 (  80   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   52 (  49 usr;   7 con; 0-4 aty)
%            Number of variables   :  779 (  20   ^; 719   !;   1   ?; 779   :)
%                                         (  39  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:38:52.386
%------------------------------------------------------------------------------
%----Could-be-implicit typings (4)
thf(ty_t_Stream_Ostream,type,
    stream: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_Int_Oint,type,
    int: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

%----Explicit typings (47)
thf(sy_cl_Rings_Odvd,type,
    dvd: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oidom,type,
    idom: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Fields_Ofield,type,
    field: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Omonoid__mult,type,
    monoid_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Divides_Osemiring__div,type,
    semiring_div: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Fields_Odivision__ring,type,
    division_ring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Osemidom__divide,type,
    semidom_divide: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Osemigroup__mult,type,
    semigroup_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocomm__monoid__mult,type,
    comm_monoid_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oalgebraic__semidom,type,
    algebraic_semidom: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Onormalization__semidom,type,
    normal1561407348emidom: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Oring__1__no__zero__divisors,type,
    ring_11004092258visors: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Osemiring__no__zero__divisors,type,
    semiri1193490041visors: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Osemiring__no__zero__divisors__cancel,type,
    semiri1923998003cancel: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Fields_Oinverse__class_Oinverse,type,
    inverse_inverse: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Groups_Oabel__semigroup,type,
    abel_semigroup: 
      !>[A: $tType] : ( ( A > A > A ) > $o ) ).

thf(sy_c_Groups_Oabel__semigroup__axioms,type,
    abel_s1917375468axioms: 
      !>[A: $tType] : ( ( A > A > A ) > $o ) ).

thf(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

thf(sy_c_Groups_Osemigroup,type,
    semigroup: 
      !>[A: $tType] : ( ( A > A > A ) > $o ) ).

thf(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_Ons,type,
    koenig_Mirabelle_ns: nat > ( stream @ nat ) ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_Oones,type,
    koenig973364414e_ones: stream @ nat ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_Oplus,type,
    koenig1738478187e_plus: ( stream @ nat ) > ( stream @ nat ) > ( stream @ nat ) ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_Oscalar,type,
    koenig1401075325scalar: nat > ( stream @ nat ) > ( stream @ nat ) ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_Otwos,type,
    koenig656342648e_twos: stream @ nat ).

thf(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

thf(sy_c_Pure_Otype,type,
    type: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Rings_Odivide__class_Odivide,type,
    divide_divide: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Rings_Odvd__class_Odvd,type,
    dvd_dvd: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Rings_Onormalization__semidom__class_Onormalize,type,
    normal1132893779malize: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Rings_Onormalization__semidom__class_Ounit__factor,type,
    normal627294541factor: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Rings_Ozero__neq__one__class_Oof__bool,type,
    zero_neq_one_of_bool: 
      !>[A: $tType] : ( $o > A ) ).

thf(sy_c_Stream_Ostream_Ostl,type,
    stl: 
      !>[A: $tType] : ( ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_v_m,type,
    m: nat ).

thf(sy_v_n,type,
    n: nat ).

thf(sy_v_xs,type,
    xs: stream @ nat ).

%----Relevant facts (253)
thf(fact_0_ns__def,axiom,
    ( koenig_Mirabelle_ns
    = ( ^ [N: nat] : ( koenig1401075325scalar @ N @ koenig973364414e_ones ) ) ) ).

% ns_def
thf(fact_1_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( times_times @ A @ A2 @ B ) @ C )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B @ C ) ) ) ) ).

% ab_semigroup_mult_class.mult_ac(1)
thf(fact_2_linordered__field__class_Osign__simps_I25_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( times_times @ A @ B @ ( times_times @ A @ A2 @ C ) )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B @ C ) ) ) ) ).

% linordered_field_class.sign_simps(25)
thf(fact_3_linordered__field__class_Osign__simps_I24_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type @ A ) )
     => ( ( times_times @ A )
        = ( ^ [A3: A,B2: A] : ( times_times @ A @ B2 @ A3 ) ) ) ) ).

% linordered_field_class.sign_simps(24)
thf(fact_4_linordered__field__class_Osign__simps_I23_J,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( times_times @ A @ A2 @ B ) @ C )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B @ C ) ) ) ) ).

% linordered_field_class.sign_simps(23)
thf(fact_5_semiring__normalization__rules_I19_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [Lx: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ Lx @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Rx @ ( times_times @ A @ Lx @ Ry ) ) ) ) ).

% semiring_normalization_rules(19)
thf(fact_6_semiring__normalization__rules_I18_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [Lx: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ Lx @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ Ry ) ) ) ).

% semiring_normalization_rules(18)
thf(fact_7_semiring__normalization__rules_I17_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [Lx: A,Ly: A,Rx: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Rx )
          = ( times_times @ A @ Lx @ ( times_times @ A @ Ly @ Rx ) ) ) ) ).

% semiring_normalization_rules(17)
thf(fact_8_semiring__normalization__rules_I16_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [Lx: A,Ly: A,Rx: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Rx )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ Ly ) ) ) ).

% semiring_normalization_rules(16)
thf(fact_9_semiring__normalization__rules_I15_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Rx @ ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Ry ) ) ) ) ).

% semiring_normalization_rules(15)
thf(fact_10_semiring__normalization__rules_I14_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Lx @ ( times_times @ A @ Ly @ ( times_times @ A @ Rx @ Ry ) ) ) ) ) ).

% semiring_normalization_rules(14)
thf(fact_11_semiring__normalization__rules_I13_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ ( times_times @ A @ Ly @ Ry ) ) ) ) ).

% semiring_normalization_rules(13)
thf(fact_12_mult_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( times_times @ A @ B @ ( times_times @ A @ A2 @ C ) )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B @ C ) ) ) ) ).

% mult.left_commute
thf(fact_13_mult_Ocommute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type @ A ) )
     => ( ( times_times @ A )
        = ( ^ [A3: A,B2: A] : ( times_times @ A @ B2 @ A3 ) ) ) ) ).

% mult.commute
thf(fact_14_mult_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semigroup_mult @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ ( times_times @ A @ A2 @ B ) @ C )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B @ C ) ) ) ) ).

% mult.assoc
thf(fact_15_semiring__normalization__rules_I7_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ( ( times_times @ A )
        = ( ^ [A3: A,B2: A] : ( times_times @ A @ B2 @ A3 ) ) ) ) ).

% semiring_normalization_rules(7)
thf(fact_16_mult_Oabel__semigroup__axioms,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type @ A ) )
     => ( abel_semigroup @ A @ ( times_times @ A ) ) ) ).

% mult.abel_semigroup_axioms
thf(fact_17_mult_Osemigroup__axioms,axiom,
    ! [A: $tType] :
      ( ( semigroup_mult @ A @ ( type @ A ) )
     => ( semigroup @ A @ ( times_times @ A ) ) ) ).

% mult.semigroup_axioms
thf(fact_18_ones_Osimps_I2_J,axiom,
    ( ( stl @ nat @ koenig973364414e_ones )
    = koenig973364414e_ones ) ).

% ones.simps(2)
thf(fact_19_of__nat__mult,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A @ ( type @ A ) )
     => ! [M: nat,N2: nat] :
          ( ( semiring_1_of_nat @ A @ ( times_times @ nat @ M @ N2 ) )
          = ( times_times @ A @ ( semiring_1_of_nat @ A @ M ) @ ( semiring_1_of_nat @ A @ N2 ) ) ) ) ).

% of_nat_mult
thf(fact_20_mult_Oright__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_mult @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( one_one @ A ) )
          = A2 ) ) ).

% mult.right_neutral
thf(fact_21_mult_Oleft__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_mult @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( one_one @ A ) @ A2 )
          = A2 ) ) ).

% mult.left_neutral
thf(fact_22_times__divide__eq__right,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( times_times @ A @ A2 @ ( divide_divide @ A @ B @ C ) )
          = ( divide_divide @ A @ ( times_times @ A @ A2 @ B ) @ C ) ) ) ).

% times_divide_eq_right
thf(fact_23_divide__divide__eq__right,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( divide_divide @ A @ A2 @ ( divide_divide @ A @ B @ C ) )
          = ( divide_divide @ A @ ( times_times @ A @ A2 @ C ) @ B ) ) ) ).

% divide_divide_eq_right
thf(fact_24_divide__divide__eq__left,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( divide_divide @ A @ ( divide_divide @ A @ A2 @ B ) @ C )
          = ( divide_divide @ A @ A2 @ ( times_times @ A @ B @ C ) ) ) ) ).

% divide_divide_eq_left
thf(fact_25_times__divide__eq__left,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [B: A,C: A,A2: A] :
          ( ( times_times @ A @ ( divide_divide @ A @ B @ C ) @ A2 )
          = ( divide_divide @ A @ ( times_times @ A @ B @ A2 ) @ C ) ) ) ).

% times_divide_eq_left
thf(fact_26_inverse__mult__distrib,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( inverse_inverse @ A @ ( times_times @ A @ A2 @ B ) )
          = ( times_times @ A @ ( inverse_inverse @ A @ A2 ) @ ( inverse_inverse @ A @ B ) ) ) ) ).

% inverse_mult_distrib
thf(fact_27_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type @ A ) )
     => ! [M: nat,N2: nat] :
          ( ( ( semiring_1_of_nat @ A @ M )
            = ( semiring_1_of_nat @ A @ N2 ) )
          = ( M = N2 ) ) ) ).

% of_nat_eq_iff
thf(fact_28_nat__1__eq__mult__iff,axiom,
    ! [M: nat,N2: nat] :
      ( ( ( one_one @ nat )
        = ( times_times @ nat @ M @ N2 ) )
      = ( ( M
          = ( one_one @ nat ) )
        & ( N2
          = ( one_one @ nat ) ) ) ) ).

% nat_1_eq_mult_iff
thf(fact_29_nat__mult__eq__1__iff,axiom,
    ! [M: nat,N2: nat] :
      ( ( ( times_times @ nat @ M @ N2 )
        = ( one_one @ nat ) )
      = ( ( M
          = ( one_one @ nat ) )
        & ( N2
          = ( one_one @ nat ) ) ) ) ).

% nat_mult_eq_1_iff
thf(fact_30_inverse__eq__iff__eq,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( inverse_inverse @ A @ A2 )
            = ( inverse_inverse @ A @ B ) )
          = ( A2 = B ) ) ) ).

% inverse_eq_iff_eq
thf(fact_31_inverse__inverse__eq,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( inverse_inverse @ A @ ( inverse_inverse @ A @ A2 ) )
          = A2 ) ) ).

% inverse_inverse_eq
thf(fact_32_of__nat__1,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A @ ( type @ A ) )
     => ( ( semiring_1_of_nat @ A @ ( one_one @ nat ) )
        = ( one_one @ A ) ) ) ).

% of_nat_1
thf(fact_33_inverse__eq__1__iff,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [X: A] :
          ( ( ( inverse_inverse @ A @ X )
            = ( one_one @ A ) )
          = ( X
            = ( one_one @ A ) ) ) ) ).

% inverse_eq_1_iff
thf(fact_34_inverse__1,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ( ( inverse_inverse @ A @ ( one_one @ A ) )
        = ( one_one @ A ) ) ) ).

% inverse_1
thf(fact_35_inverse__divide,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( inverse_inverse @ A @ ( divide_divide @ A @ A2 @ B ) )
          = ( divide_divide @ A @ B @ A2 ) ) ) ).

% inverse_divide
thf(fact_36_abel__semigroup_Oaxioms_I1_J,axiom,
    ! [A: $tType,F: A > A > A] :
      ( ( abel_semigroup @ A @ F )
     => ( semigroup @ A @ F ) ) ).

% abel_semigroup.axioms(1)
thf(fact_37_one__reorient,axiom,
    ! [A: $tType] :
      ( ( one @ A @ ( type @ A ) )
     => ! [X: A] :
          ( ( ( one_one @ A )
            = X )
          = ( X
            = ( one_one @ A ) ) ) ) ).

% one_reorient
thf(fact_38_semigroup__def,axiom,
    ! [A: $tType] :
      ( ( semigroup @ A )
      = ( ^ [F2: A > A > A] :
          ! [A3: A,B2: A,C2: A] :
            ( ( F2 @ ( F2 @ A3 @ B2 ) @ C2 )
            = ( F2 @ A3 @ ( F2 @ B2 @ C2 ) ) ) ) ) ).

% semigroup_def
thf(fact_39_semigroup_Oassoc,axiom,
    ! [A: $tType,F: A > A > A,A2: A,B: A,C: A] :
      ( ( semigroup @ A @ F )
     => ( ( F @ ( F @ A2 @ B ) @ C )
        = ( F @ A2 @ ( F @ B @ C ) ) ) ) ).

% semigroup.assoc
thf(fact_40_semigroup_Ointro,axiom,
    ! [A: $tType,F: A > A > A] :
      ( ! [A4: A,B3: A,C3: A] :
          ( ( F @ ( F @ A4 @ B3 ) @ C3 )
          = ( F @ A4 @ ( F @ B3 @ C3 ) ) )
     => ( semigroup @ A @ F ) ) ).

% semigroup.intro
thf(fact_41_abel__semigroup_Ocommute,axiom,
    ! [A: $tType,F: A > A > A,A2: A,B: A] :
      ( ( abel_semigroup @ A @ F )
     => ( ( F @ A2 @ B )
        = ( F @ B @ A2 ) ) ) ).

% abel_semigroup.commute
thf(fact_42_abel__semigroup_Oleft__commute,axiom,
    ! [A: $tType,F: A > A > A,B: A,A2: A,C: A] :
      ( ( abel_semigroup @ A @ F )
     => ( ( F @ B @ ( F @ A2 @ C ) )
        = ( F @ A2 @ ( F @ B @ C ) ) ) ) ).

% abel_semigroup.left_commute
thf(fact_43_field__class_Ofield__divide__inverse,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ( ( divide_divide @ A )
        = ( ^ [A3: A,B2: A] : ( times_times @ A @ A3 @ ( inverse_inverse @ A @ B2 ) ) ) ) ) ).

% field_class.field_divide_inverse
thf(fact_44_ext,axiom,
    ! [B4: $tType,A: $tType,F: A > B4,G: A > B4] :
      ( ! [X2: A] :
          ( ( F @ X2 )
          = ( G @ X2 ) )
     => ( F = G ) ) ).

% ext
thf(fact_45_divide__inverse,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ( ( divide_divide @ A )
        = ( ^ [A3: A,B2: A] : ( times_times @ A @ A3 @ ( inverse_inverse @ A @ B2 ) ) ) ) ) ).

% divide_inverse
thf(fact_46_divide__inverse__commute,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ( ( divide_divide @ A )
        = ( ^ [A3: A,B2: A] : ( times_times @ A @ ( inverse_inverse @ A @ B2 ) @ A3 ) ) ) ) ).

% divide_inverse_commute
thf(fact_47_inverse__eq__divide,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ( ( inverse_inverse @ A )
        = ( divide_divide @ A @ ( one_one @ A ) ) ) ) ).

% inverse_eq_divide
thf(fact_48_inverse__eq__imp__eq,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( inverse_inverse @ A @ A2 )
            = ( inverse_inverse @ A @ B ) )
         => ( A2 = B ) ) ) ).

% inverse_eq_imp_eq
thf(fact_49_inverse__unique,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( times_times @ A @ A2 @ B )
            = ( one_one @ A ) )
         => ( ( inverse_inverse @ A @ A2 )
            = B ) ) ) ).

% inverse_unique
thf(fact_50_mult__of__nat__commute,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A @ ( type @ A ) )
     => ! [X: nat,Y: A] :
          ( ( times_times @ A @ ( semiring_1_of_nat @ A @ X ) @ Y )
          = ( times_times @ A @ Y @ ( semiring_1_of_nat @ A @ X ) ) ) ) ).

% mult_of_nat_commute
thf(fact_51_nat__mult__1,axiom,
    ! [N2: nat] :
      ( ( times_times @ nat @ ( one_one @ nat ) @ N2 )
      = N2 ) ).

% nat_mult_1
thf(fact_52_nat__mult__1__right,axiom,
    ! [N2: nat] :
      ( ( times_times @ nat @ N2 @ ( one_one @ nat ) )
      = N2 ) ).

% nat_mult_1_right
thf(fact_53_times__divide__times__eq,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [X: A,Y: A,Z: A,W: A] :
          ( ( times_times @ A @ ( divide_divide @ A @ X @ Y ) @ ( divide_divide @ A @ Z @ W ) )
          = ( divide_divide @ A @ ( times_times @ A @ X @ Z ) @ ( times_times @ A @ Y @ W ) ) ) ) ).

% times_divide_times_eq
thf(fact_54_divide__divide__times__eq,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [X: A,Y: A,Z: A,W: A] :
          ( ( divide_divide @ A @ ( divide_divide @ A @ X @ Y ) @ ( divide_divide @ A @ Z @ W ) )
          = ( divide_divide @ A @ ( times_times @ A @ X @ W ) @ ( times_times @ A @ Y @ Z ) ) ) ) ).

% divide_divide_times_eq
thf(fact_55_semiring__normalization__rules_I12_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( one_one @ A ) )
          = A2 ) ) ).

% semiring_normalization_rules(12)
thf(fact_56_semiring__normalization__rules_I11_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( one_one @ A ) @ A2 )
          = A2 ) ) ).

% semiring_normalization_rules(11)
thf(fact_57_comm__monoid__mult__class_Omult__1,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( one_one @ A ) @ A2 )
          = A2 ) ) ).

% comm_monoid_mult_class.mult_1
thf(fact_58_mult_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( one_one @ A ) )
          = A2 ) ) ).

% mult.comm_neutral
thf(fact_59_divide__1,axiom,
    ! [A: $tType] :
      ( ( semidom_divide @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( divide_divide @ A @ A2 @ ( one_one @ A ) )
          = A2 ) ) ).

% divide_1
thf(fact_60_div__by__1,axiom,
    ! [A: $tType] :
      ( ( semiring_div @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( divide_divide @ A @ A2 @ ( one_one @ A ) )
          = A2 ) ) ).

% div_by_1
thf(fact_61_abel__semigroup__def,axiom,
    ! [A: $tType] :
      ( ( abel_semigroup @ A )
      = ( ^ [F2: A > A > A] :
            ( ( semigroup @ A @ F2 )
            & ( abel_s1917375468axioms @ A @ F2 ) ) ) ) ).

% abel_semigroup_def
thf(fact_62_abel__semigroup_Ointro,axiom,
    ! [A: $tType,F: A > A > A] :
      ( ( semigroup @ A @ F )
     => ( ( abel_s1917375468axioms @ A @ F )
       => ( abel_semigroup @ A @ F ) ) ) ).

% abel_semigroup.intro
thf(fact_63_twos_Osimps_I2_J,axiom,
    ( ( stl @ nat @ koenig656342648e_twos )
    = koenig656342648e_twos ) ).

% twos.simps(2)
thf(fact_64_left__inverse,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( times_times @ A @ ( inverse_inverse @ A @ A2 ) @ A2 )
            = ( one_one @ A ) ) ) ) ).

% left_inverse
thf(fact_65_right__inverse,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( times_times @ A @ A2 @ ( inverse_inverse @ A @ A2 ) )
            = ( one_one @ A ) ) ) ) ).

% right_inverse
thf(fact_66_plus_Osimps_I2_J,axiom,
    ! [Xs: stream @ nat,Ys: stream @ nat] :
      ( ( stl @ nat @ ( koenig1738478187e_plus @ Xs @ Ys ) )
      = ( koenig1738478187e_plus @ ( stl @ nat @ Xs ) @ ( stl @ nat @ Ys ) ) ) ).

% plus.simps(2)
thf(fact_67_nonzero__divide__mult__cancel__left,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ A2 @ ( times_times @ A @ A2 @ B ) )
            = ( divide_divide @ A @ ( one_one @ A ) @ B ) ) ) ) ).

% nonzero_divide_mult_cancel_left
thf(fact_68_mult__cancel2,axiom,
    ! [M: nat,K: nat,N2: nat] :
      ( ( ( times_times @ nat @ M @ K )
        = ( times_times @ nat @ N2 @ K ) )
      = ( ( M = N2 )
        | ( K
          = ( zero_zero @ nat ) ) ) ) ).

% mult_cancel2
thf(fact_69_mult__cancel1,axiom,
    ! [K: nat,M: nat,N2: nat] :
      ( ( ( times_times @ nat @ K @ M )
        = ( times_times @ nat @ K @ N2 ) )
      = ( ( M = N2 )
        | ( K
          = ( zero_zero @ nat ) ) ) ) ).

% mult_cancel1
thf(fact_70_mult__0__right,axiom,
    ! [M: nat] :
      ( ( times_times @ nat @ M @ ( zero_zero @ nat ) )
      = ( zero_zero @ nat ) ) ).

% mult_0_right
thf(fact_71_mult__is__0,axiom,
    ! [M: nat,N2: nat] :
      ( ( ( times_times @ nat @ M @ N2 )
        = ( zero_zero @ nat ) )
      = ( ( M
          = ( zero_zero @ nat ) )
        | ( N2
          = ( zero_zero @ nat ) ) ) ) ).

% mult_is_0
thf(fact_72_mult__cancel__right,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A @ ( type @ A ) )
     => ! [A2: A,C: A,B: A] :
          ( ( ( times_times @ A @ A2 @ C )
            = ( times_times @ A @ B @ C ) )
          = ( ( C
              = ( zero_zero @ A ) )
            | ( A2 = B ) ) ) ) ).

% mult_cancel_right
thf(fact_73_mult__cancel__left,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A @ ( type @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( ( times_times @ A @ C @ A2 )
            = ( times_times @ A @ C @ B ) )
          = ( ( C
              = ( zero_zero @ A ) )
            | ( A2 = B ) ) ) ) ).

% mult_cancel_left
thf(fact_74_mult__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiri1193490041visors @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( times_times @ A @ A2 @ B )
            = ( zero_zero @ A ) )
          = ( ( A2
              = ( zero_zero @ A ) )
            | ( B
              = ( zero_zero @ A ) ) ) ) ) ).

% mult_eq_0_iff
thf(fact_75_mult__zero__right,axiom,
    ! [A: $tType] :
      ( ( mult_zero @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( zero_zero @ A ) )
          = ( zero_zero @ A ) ) ) ).

% mult_zero_right
thf(fact_76_mult__zero__left,axiom,
    ! [A: $tType] :
      ( ( mult_zero @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( zero_zero @ A ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% mult_zero_left
thf(fact_77_div__0,axiom,
    ! [A: $tType] :
      ( ( semiring_div @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( divide_divide @ A @ ( zero_zero @ A ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% div_0
thf(fact_78_div__by__0,axiom,
    ! [A: $tType] :
      ( ( semiring_div @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( divide_divide @ A @ A2 @ ( zero_zero @ A ) )
          = ( zero_zero @ A ) ) ) ).

% div_by_0
thf(fact_79_divide__zero,axiom,
    ! [A: $tType] :
      ( ( semidom_divide @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( divide_divide @ A @ A2 @ ( zero_zero @ A ) )
          = ( zero_zero @ A ) ) ) ).

% divide_zero
thf(fact_80_divide__zero__left,axiom,
    ! [A: $tType] :
      ( ( semidom_divide @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( divide_divide @ A @ ( zero_zero @ A ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% divide_zero_left
thf(fact_81_division__ring__divide__zero,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( divide_divide @ A @ A2 @ ( zero_zero @ A ) )
          = ( zero_zero @ A ) ) ) ).

% division_ring_divide_zero
thf(fact_82_divide__cancel__right,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [A2: A,C: A,B: A] :
          ( ( ( divide_divide @ A @ A2 @ C )
            = ( divide_divide @ A @ B @ C ) )
          = ( ( C
              = ( zero_zero @ A ) )
            | ( A2 = B ) ) ) ) ).

% divide_cancel_right
thf(fact_83_divide__cancel__left,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( ( divide_divide @ A @ C @ A2 )
            = ( divide_divide @ A @ C @ B ) )
          = ( ( C
              = ( zero_zero @ A ) )
            | ( A2 = B ) ) ) ) ).

% divide_cancel_left
thf(fact_84_divide__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( divide_divide @ A @ A2 @ B )
            = ( zero_zero @ A ) )
          = ( ( A2
              = ( zero_zero @ A ) )
            | ( B
              = ( zero_zero @ A ) ) ) ) ) ).

% divide_eq_0_iff
thf(fact_85_of__nat__0,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A @ ( type @ A ) )
     => ( ( semiring_1_of_nat @ A @ ( zero_zero @ nat ) )
        = ( zero_zero @ A ) ) ) ).

% of_nat_0
thf(fact_86_of__nat__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type @ A ) )
     => ! [N2: nat] :
          ( ( ( zero_zero @ A )
            = ( semiring_1_of_nat @ A @ N2 ) )
          = ( ( zero_zero @ nat )
            = N2 ) ) ) ).

% of_nat_0_eq_iff
thf(fact_87_of__nat__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type @ A ) )
     => ! [M: nat] :
          ( ( ( semiring_1_of_nat @ A @ M )
            = ( zero_zero @ A ) )
          = ( M
            = ( zero_zero @ nat ) ) ) ) ).

% of_nat_eq_0_iff
thf(fact_88_inverse__nonzero__iff__nonzero,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( ( inverse_inverse @ A @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% inverse_nonzero_iff_nonzero
thf(fact_89_inverse__zero,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ( ( inverse_inverse @ A @ ( zero_zero @ A ) )
        = ( zero_zero @ A ) ) ) ).

% inverse_zero
thf(fact_90_mult__cancel__right2,axiom,
    ! [A: $tType] :
      ( ( ring_11004092258visors @ A @ ( type @ A ) )
     => ! [A2: A,C: A] :
          ( ( ( times_times @ A @ A2 @ C )
            = C )
          = ( ( C
              = ( zero_zero @ A ) )
            | ( A2
              = ( one_one @ A ) ) ) ) ) ).

% mult_cancel_right2
thf(fact_91_mult__cancel__right1,axiom,
    ! [A: $tType] :
      ( ( ring_11004092258visors @ A @ ( type @ A ) )
     => ! [C: A,B: A] :
          ( ( C
            = ( times_times @ A @ B @ C ) )
          = ( ( C
              = ( zero_zero @ A ) )
            | ( B
              = ( one_one @ A ) ) ) ) ) ).

% mult_cancel_right1
thf(fact_92_mult__cancel__left2,axiom,
    ! [A: $tType] :
      ( ( ring_11004092258visors @ A @ ( type @ A ) )
     => ! [C: A,A2: A] :
          ( ( ( times_times @ A @ C @ A2 )
            = C )
          = ( ( C
              = ( zero_zero @ A ) )
            | ( A2
              = ( one_one @ A ) ) ) ) ) ).

% mult_cancel_left2
thf(fact_93_mult__cancel__left1,axiom,
    ! [A: $tType] :
      ( ( ring_11004092258visors @ A @ ( type @ A ) )
     => ! [C: A,B: A] :
          ( ( C
            = ( times_times @ A @ C @ B ) )
          = ( ( C
              = ( zero_zero @ A ) )
            | ( B
              = ( one_one @ A ) ) ) ) ) ).

% mult_cancel_left1
thf(fact_94_nonzero__mult__divide__cancel__right,axiom,
    ! [A: $tType] :
      ( ( semidom_divide @ A @ ( type @ A ) )
     => ! [B: A,A2: A] :
          ( ( B
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ A2 @ B ) @ B )
            = A2 ) ) ) ).

% nonzero_mult_divide_cancel_right
thf(fact_95_nonzero__mult__divide__cancel__left,axiom,
    ! [A: $tType] :
      ( ( semidom_divide @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ A2 @ B ) @ A2 )
            = B ) ) ) ).

% nonzero_mult_divide_cancel_left
thf(fact_96_div__mult__mult1__if,axiom,
    ! [A: $tType] :
      ( ( semiring_div @ A @ ( type @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( ( C
              = ( zero_zero @ A ) )
           => ( ( divide_divide @ A @ ( times_times @ A @ C @ A2 ) @ ( times_times @ A @ C @ B ) )
              = ( zero_zero @ A ) ) )
          & ( ( C
             != ( zero_zero @ A ) )
           => ( ( divide_divide @ A @ ( times_times @ A @ C @ A2 ) @ ( times_times @ A @ C @ B ) )
              = ( divide_divide @ A @ A2 @ B ) ) ) ) ) ).

% div_mult_mult1_if
thf(fact_97_div__mult__mult2,axiom,
    ! [A: $tType] :
      ( ( semiring_div @ A @ ( type @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( C
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ C ) )
            = ( divide_divide @ A @ A2 @ B ) ) ) ) ).

% div_mult_mult2
thf(fact_98_div__mult__mult1,axiom,
    ! [A: $tType] :
      ( ( semiring_div @ A @ ( type @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( C
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ C @ A2 ) @ ( times_times @ A @ C @ B ) )
            = ( divide_divide @ A @ A2 @ B ) ) ) ) ).

% div_mult_mult1
thf(fact_99_mult__divide__mult__cancel__left__if,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( ( C
              = ( zero_zero @ A ) )
           => ( ( divide_divide @ A @ ( times_times @ A @ C @ A2 ) @ ( times_times @ A @ C @ B ) )
              = ( zero_zero @ A ) ) )
          & ( ( C
             != ( zero_zero @ A ) )
           => ( ( divide_divide @ A @ ( times_times @ A @ C @ A2 ) @ ( times_times @ A @ C @ B ) )
              = ( divide_divide @ A @ A2 @ B ) ) ) ) ) ).

% mult_divide_mult_cancel_left_if
thf(fact_100_nonzero__mult__divide__mult__cancel__left,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( C
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ C @ A2 ) @ ( times_times @ A @ C @ B ) )
            = ( divide_divide @ A @ A2 @ B ) ) ) ) ).

% nonzero_mult_divide_mult_cancel_left
thf(fact_101_nonzero__mult__divide__mult__cancel__left2,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( C
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ C @ A2 ) @ ( times_times @ A @ B @ C ) )
            = ( divide_divide @ A @ A2 @ B ) ) ) ) ).

% nonzero_mult_divide_mult_cancel_left2
thf(fact_102_nonzero__mult__divide__mult__cancel__right,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( C
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ C ) )
            = ( divide_divide @ A @ A2 @ B ) ) ) ) ).

% nonzero_mult_divide_mult_cancel_right
thf(fact_103_nonzero__mult__divide__mult__cancel__right2,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( C
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ C @ B ) )
            = ( divide_divide @ A @ A2 @ B ) ) ) ) ).

% nonzero_mult_divide_mult_cancel_right2
thf(fact_104_div__self,axiom,
    ! [A: $tType] :
      ( ( semidom_divide @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ A2 @ A2 )
            = ( one_one @ A ) ) ) ) ).

% div_self
thf(fact_105_zero__eq__1__divide__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( ( zero_zero @ A )
            = ( divide_divide @ A @ ( one_one @ A ) @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% zero_eq_1_divide_iff
thf(fact_106_one__divide__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( ( divide_divide @ A @ ( one_one @ A ) @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% one_divide_eq_0_iff
thf(fact_107_eq__divide__eq__1,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type @ A ) )
     => ! [B: A,A2: A] :
          ( ( ( one_one @ A )
            = ( divide_divide @ A @ B @ A2 ) )
          = ( ( A2
             != ( zero_zero @ A ) )
            & ( A2 = B ) ) ) ) ).

% eq_divide_eq_1
thf(fact_108_divide__eq__eq__1,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type @ A ) )
     => ! [B: A,A2: A] :
          ( ( ( divide_divide @ A @ B @ A2 )
            = ( one_one @ A ) )
          = ( ( A2
             != ( zero_zero @ A ) )
            & ( A2 = B ) ) ) ) ).

% divide_eq_eq_1
thf(fact_109_divide__self__if,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( ( A2
              = ( zero_zero @ A ) )
           => ( ( divide_divide @ A @ A2 @ A2 )
              = ( zero_zero @ A ) ) )
          & ( ( A2
             != ( zero_zero @ A ) )
           => ( ( divide_divide @ A @ A2 @ A2 )
              = ( one_one @ A ) ) ) ) ) ).

% divide_self_if
thf(fact_110_divide__self,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ A2 @ A2 )
            = ( one_one @ A ) ) ) ) ).

% divide_self
thf(fact_111_one__eq__divide__iff,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( one_one @ A )
            = ( divide_divide @ A @ A2 @ B ) )
          = ( ( B
             != ( zero_zero @ A ) )
            & ( A2 = B ) ) ) ) ).

% one_eq_divide_iff
thf(fact_112_divide__eq__1__iff,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( divide_divide @ A @ A2 @ B )
            = ( one_one @ A ) )
          = ( ( B
             != ( zero_zero @ A ) )
            & ( A2 = B ) ) ) ) ).

% divide_eq_1_iff
thf(fact_113_nonzero__divide__mult__cancel__right,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [B: A,A2: A] :
          ( ( B
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ B @ ( times_times @ A @ A2 @ B ) )
            = ( divide_divide @ A @ ( one_one @ A ) @ A2 ) ) ) ) ).

% nonzero_divide_mult_cancel_right
thf(fact_114_div__eq__dividend__iff,axiom,
    ! [A2: nat,B: nat] :
      ( ( A2
       != ( zero_zero @ nat ) )
     => ( ( ( divide_divide @ nat @ A2 @ B )
          = A2 )
        = ( B
          = ( one_one @ nat ) ) ) ) ).

% div_eq_dividend_iff
thf(fact_115_zero__reorient,axiom,
    ! [A: $tType] :
      ( ( zero @ A @ ( type @ A ) )
     => ! [X: A] :
          ( ( ( zero_zero @ A )
            = X )
          = ( X
            = ( zero_zero @ A ) ) ) ) ).

% zero_reorient
thf(fact_116_mult__right__cancel,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A @ ( type @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( C
           != ( zero_zero @ A ) )
         => ( ( ( times_times @ A @ A2 @ C )
              = ( times_times @ A @ B @ C ) )
            = ( A2 = B ) ) ) ) ).

% mult_right_cancel
thf(fact_117_mult__left__cancel,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A @ ( type @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( C
           != ( zero_zero @ A ) )
         => ( ( ( times_times @ A @ C @ A2 )
              = ( times_times @ A @ C @ B ) )
            = ( A2 = B ) ) ) ) ).

% mult_left_cancel
thf(fact_118_no__zero__divisors,axiom,
    ! [A: $tType] :
      ( ( semiri1193490041visors @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( B
             != ( zero_zero @ A ) )
           => ( ( times_times @ A @ A2 @ B )
             != ( zero_zero @ A ) ) ) ) ) ).

% no_zero_divisors
thf(fact_119_divisors__zero,axiom,
    ! [A: $tType] :
      ( ( semiri1193490041visors @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( times_times @ A @ A2 @ B )
            = ( zero_zero @ A ) )
         => ( ( A2
              = ( zero_zero @ A ) )
            | ( B
              = ( zero_zero @ A ) ) ) ) ) ).

% divisors_zero
thf(fact_120_mult__not__zero,axiom,
    ! [A: $tType] :
      ( ( mult_zero @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( times_times @ A @ A2 @ B )
           != ( zero_zero @ A ) )
         => ( ( A2
             != ( zero_zero @ A ) )
            & ( B
             != ( zero_zero @ A ) ) ) ) ) ).

% mult_not_zero
thf(fact_121_zero__neq__one,axiom,
    ! [A: $tType] :
      ( ( zero_neq_one @ A @ ( type @ A ) )
     => ( ( zero_zero @ A )
       != ( one_one @ A ) ) ) ).

% zero_neq_one
thf(fact_122_abel__semigroup__axioms__def,axiom,
    ! [A: $tType] :
      ( ( abel_s1917375468axioms @ A )
      = ( ^ [F2: A > A > A] :
          ! [A3: A,B2: A] :
            ( ( F2 @ A3 @ B2 )
            = ( F2 @ B2 @ A3 ) ) ) ) ).

% abel_semigroup_axioms_def
thf(fact_123_abel__semigroup__axioms_Ointro,axiom,
    ! [A: $tType,F: A > A > A] :
      ( ! [A4: A,B3: A] :
          ( ( F @ A4 @ B3 )
          = ( F @ B3 @ A4 ) )
     => ( abel_s1917375468axioms @ A @ F ) ) ).

% abel_semigroup_axioms.intro
thf(fact_124_semiring__normalization__rules_I9_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( zero_zero @ A ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% semiring_normalization_rules(9)
thf(fact_125_semiring__normalization__rules_I10_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( zero_zero @ A ) )
          = ( zero_zero @ A ) ) ) ).

% semiring_normalization_rules(10)
thf(fact_126_mult__0,axiom,
    ! [N2: nat] :
      ( ( times_times @ nat @ ( zero_zero @ nat ) @ N2 )
      = ( zero_zero @ nat ) ) ).

% mult_0
thf(fact_127_mult__eq__self__implies__10,axiom,
    ! [M: nat,N2: nat] :
      ( ( M
        = ( times_times @ nat @ M @ N2 ) )
     => ( ( N2
          = ( one_one @ nat ) )
        | ( M
          = ( zero_zero @ nat ) ) ) ) ).

% mult_eq_self_implies_10
thf(fact_128_nonzero__imp__inverse__nonzero,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( inverse_inverse @ A @ A2 )
           != ( zero_zero @ A ) ) ) ) ).

% nonzero_imp_inverse_nonzero
thf(fact_129_nonzero__inverse__inverse__eq,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( inverse_inverse @ A @ ( inverse_inverse @ A @ A2 ) )
            = A2 ) ) ) ).

% nonzero_inverse_inverse_eq
thf(fact_130_nonzero__inverse__eq__imp__eq,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( inverse_inverse @ A @ A2 )
            = ( inverse_inverse @ A @ B ) )
         => ( ( A2
             != ( zero_zero @ A ) )
           => ( ( B
               != ( zero_zero @ A ) )
             => ( A2 = B ) ) ) ) ) ).

% nonzero_inverse_eq_imp_eq
thf(fact_131_inverse__zero__imp__zero,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( ( inverse_inverse @ A @ A2 )
            = ( zero_zero @ A ) )
         => ( A2
            = ( zero_zero @ A ) ) ) ) ).

% inverse_zero_imp_zero
thf(fact_132_field__class_Ofield__inverse__zero,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ( ( inverse_inverse @ A @ ( zero_zero @ A ) )
        = ( zero_zero @ A ) ) ) ).

% field_class.field_inverse_zero
thf(fact_133_div__mult__self2__is__id,axiom,
    ! [A: $tType] :
      ( ( semiring_div @ A @ ( type @ A ) )
     => ! [B: A,A2: A] :
          ( ( B
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ A2 @ B ) @ B )
            = A2 ) ) ) ).

% div_mult_self2_is_id
thf(fact_134_div__mult__self1__is__id,axiom,
    ! [A: $tType] :
      ( ( semiring_div @ A @ ( type @ A ) )
     => ! [B: A,A2: A] :
          ( ( B
           != ( zero_zero @ A ) )
         => ( ( divide_divide @ A @ ( times_times @ A @ B @ A2 ) @ B )
            = A2 ) ) ) ).

% div_mult_self1_is_id
thf(fact_135_frac__eq__eq,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [Y: A,Z: A,X: A,W: A] :
          ( ( Y
           != ( zero_zero @ A ) )
         => ( ( Z
             != ( zero_zero @ A ) )
           => ( ( ( divide_divide @ A @ X @ Y )
                = ( divide_divide @ A @ W @ Z ) )
              = ( ( times_times @ A @ X @ Z )
                = ( times_times @ A @ W @ Y ) ) ) ) ) ) ).

% frac_eq_eq
thf(fact_136_divide__eq__eq,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [B: A,C: A,A2: A] :
          ( ( ( divide_divide @ A @ B @ C )
            = A2 )
          = ( ( ( C
               != ( zero_zero @ A ) )
             => ( B
                = ( times_times @ A @ A2 @ C ) ) )
            & ( ( C
                = ( zero_zero @ A ) )
             => ( A2
                = ( zero_zero @ A ) ) ) ) ) ) ).

% divide_eq_eq
thf(fact_137_eq__divide__eq,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( A2
            = ( divide_divide @ A @ B @ C ) )
          = ( ( ( C
               != ( zero_zero @ A ) )
             => ( ( times_times @ A @ A2 @ C )
                = B ) )
            & ( ( C
                = ( zero_zero @ A ) )
             => ( A2
                = ( zero_zero @ A ) ) ) ) ) ) ).

% eq_divide_eq
thf(fact_138_divide__eq__imp,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [C: A,B: A,A2: A] :
          ( ( C
           != ( zero_zero @ A ) )
         => ( ( B
              = ( times_times @ A @ A2 @ C ) )
           => ( ( divide_divide @ A @ B @ C )
              = A2 ) ) ) ) ).

% divide_eq_imp
thf(fact_139_eq__divide__imp,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( C
           != ( zero_zero @ A ) )
         => ( ( ( times_times @ A @ A2 @ C )
              = B )
           => ( A2
              = ( divide_divide @ A @ B @ C ) ) ) ) ) ).

% eq_divide_imp
thf(fact_140_nonzero__divide__eq__eq,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [C: A,B: A,A2: A] :
          ( ( C
           != ( zero_zero @ A ) )
         => ( ( ( divide_divide @ A @ B @ C )
              = A2 )
            = ( B
              = ( times_times @ A @ A2 @ C ) ) ) ) ) ).

% nonzero_divide_eq_eq
thf(fact_141_nonzero__eq__divide__eq,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( C
           != ( zero_zero @ A ) )
         => ( ( A2
              = ( divide_divide @ A @ B @ C ) )
            = ( ( times_times @ A @ A2 @ C )
              = B ) ) ) ) ).

% nonzero_eq_divide_eq
thf(fact_142_right__inverse__eq,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [B: A,A2: A] :
          ( ( B
           != ( zero_zero @ A ) )
         => ( ( ( divide_divide @ A @ A2 @ B )
              = ( one_one @ A ) )
            = ( A2 = B ) ) ) ) ).

% right_inverse_eq
thf(fact_143_nonzero__inverse__mult__distrib,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( B
             != ( zero_zero @ A ) )
           => ( ( inverse_inverse @ A @ ( times_times @ A @ A2 @ B ) )
              = ( times_times @ A @ ( inverse_inverse @ A @ B ) @ ( inverse_inverse @ A @ A2 ) ) ) ) ) ) ).

% nonzero_inverse_mult_distrib
thf(fact_144_field__class_Ofield__inverse,axiom,
    ! [A: $tType] :
      ( ( field @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( times_times @ A @ ( inverse_inverse @ A @ A2 ) @ A2 )
            = ( one_one @ A ) ) ) ) ).

% field_class.field_inverse
thf(fact_145_nonzero__inverse__eq__divide,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( inverse_inverse @ A @ A2 )
            = ( divide_divide @ A @ ( one_one @ A ) @ A2 ) ) ) ) ).

% nonzero_inverse_eq_divide
thf(fact_146_abel__semigroup_Oaxioms_I2_J,axiom,
    ! [A: $tType,F: A > A > A] :
      ( ( abel_semigroup @ A @ F )
     => ( abel_s1917375468axioms @ A @ F ) ) ).

% abel_semigroup.axioms(2)
thf(fact_147_Divides_Odiv__mult2__eq,axiom,
    ! [A2: nat,B: nat,C: nat] :
      ( ( divide_divide @ nat @ A2 @ ( times_times @ nat @ B @ C ) )
      = ( divide_divide @ nat @ ( divide_divide @ nat @ A2 @ B ) @ C ) ) ).

% Divides.div_mult2_eq
thf(fact_148_nat__mult__div__cancel__disj,axiom,
    ! [K: nat,M: nat,N2: nat] :
      ( ( ( K
          = ( zero_zero @ nat ) )
       => ( ( divide_divide @ nat @ ( times_times @ nat @ K @ M ) @ ( times_times @ nat @ K @ N2 ) )
          = ( zero_zero @ nat ) ) )
      & ( ( K
         != ( zero_zero @ nat ) )
       => ( ( divide_divide @ nat @ ( times_times @ nat @ K @ M ) @ ( times_times @ nat @ K @ N2 ) )
          = ( divide_divide @ nat @ M @ N2 ) ) ) ) ).

% nat_mult_div_cancel_disj
thf(fact_149_mult__one__div__unit__factor,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( times_times @ A @ A2 @ ( divide_divide @ A @ ( one_one @ A ) @ ( normal627294541factor @ A @ B ) ) )
          = ( divide_divide @ A @ A2 @ ( normal627294541factor @ A @ B ) ) ) ) ).

% mult_one_div_unit_factor
thf(fact_150_split__of__bool__asm,axiom,
    ! [A: $tType] :
      ( ( zero_neq_one @ A @ ( type @ A ) )
     => ! [P: A > $o,P2: $o] :
          ( ( P @ ( zero_neq_one_of_bool @ A @ P2 ) )
          = ( ~ ( ( P2
                  & ~ ( P @ ( one_one @ A ) ) )
                | ( ~ P2
                  & ~ ( P @ ( zero_zero @ A ) ) ) ) ) ) ) ).

% split_of_bool_asm
thf(fact_151_split__of__bool,axiom,
    ! [A: $tType] :
      ( ( zero_neq_one @ A @ ( type @ A ) )
     => ! [P: A > $o,P2: $o] :
          ( ( P @ ( zero_neq_one_of_bool @ A @ P2 ) )
          = ( ( P2
             => ( P @ ( one_one @ A ) ) )
            & ( ~ P2
             => ( P @ ( zero_zero @ A ) ) ) ) ) ) ).

% split_of_bool
thf(fact_152_of__bool__def,axiom,
    ! [A: $tType] :
      ( ( zero_neq_one @ A @ ( type @ A ) )
     => ( ( zero_neq_one_of_bool @ A )
        = ( ^ [P3: $o] : ( if @ A @ P3 @ ( one_one @ A ) @ ( zero_zero @ A ) ) ) ) ) ).

% of_bool_def
thf(fact_153_of__bool__eq_I2_J,axiom,
    ! [A: $tType] :
      ( ( zero_neq_one @ A @ ( type @ A ) )
     => ( ( zero_neq_one_of_bool @ A @ $true )
        = ( one_one @ A ) ) ) ).

% of_bool_eq(2)
thf(fact_154_is__unit__divide__mult__cancel__right,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( dvd_dvd @ A @ B @ ( one_one @ A ) )
           => ( ( divide_divide @ A @ A2 @ ( times_times @ A @ B @ A2 ) )
              = ( divide_divide @ A @ ( one_one @ A ) @ B ) ) ) ) ) ).

% is_unit_divide_mult_cancel_right
thf(fact_155_unit__factor__simps_I1_J,axiom,
    ( ( normal627294541factor @ nat @ ( zero_zero @ nat ) )
    = ( zero_zero @ nat ) ) ).

% unit_factor_simps(1)
thf(fact_156_nat__dvd__1__iff__1,axiom,
    ! [M: nat] :
      ( ( dvd_dvd @ nat @ M @ ( one_one @ nat ) )
      = ( M
        = ( one_one @ nat ) ) ) ).

% nat_dvd_1_iff_1
thf(fact_157_unit__factor__idem,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( normal627294541factor @ A @ ( normal627294541factor @ A @ A2 ) )
          = ( normal627294541factor @ A @ A2 ) ) ) ).

% unit_factor_idem
thf(fact_158_dvd__0__left__iff,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( dvd_dvd @ A @ ( zero_zero @ A ) @ A2 )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% dvd_0_left_iff
thf(fact_159_dvd__0__right,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A] : ( dvd_dvd @ A @ A2 @ ( zero_zero @ A ) ) ) ).

% dvd_0_right
thf(fact_160_div__dvd__div,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( dvd_dvd @ A @ A2 @ B )
         => ( ( dvd_dvd @ A @ A2 @ C )
           => ( ( dvd_dvd @ A @ ( divide_divide @ A @ B @ A2 ) @ ( divide_divide @ A @ C @ A2 ) )
              = ( dvd_dvd @ A @ B @ C ) ) ) ) ) ).

% div_dvd_div
thf(fact_161_nat__mult__dvd__cancel__disj,axiom,
    ! [K: nat,M: nat,N2: nat] :
      ( ( dvd_dvd @ nat @ ( times_times @ nat @ K @ M ) @ ( times_times @ nat @ K @ N2 ) )
      = ( ( K
          = ( zero_zero @ nat ) )
        | ( dvd_dvd @ nat @ M @ N2 ) ) ) ).

% nat_mult_dvd_cancel_disj
thf(fact_162_unit__factor__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( ( normal627294541factor @ A @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% unit_factor_eq_0_iff
thf(fact_163_unit__factor__0,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ( ( normal627294541factor @ A @ ( zero_zero @ A ) )
        = ( zero_zero @ A ) ) ) ).

% unit_factor_0
thf(fact_164_unit__factor__1,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ( ( normal627294541factor @ A @ ( one_one @ A ) )
        = ( one_one @ A ) ) ) ).

% unit_factor_1
thf(fact_165_of__bool__eq_I1_J,axiom,
    ! [A: $tType] :
      ( ( zero_neq_one @ A @ ( type @ A ) )
     => ( ( zero_neq_one_of_bool @ A @ $false )
        = ( zero_zero @ A ) ) ) ).

% of_bool_eq(1)
thf(fact_166_dvd__mult__cancel__left,axiom,
    ! [A: $tType] :
      ( ( idom @ A @ ( type @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( dvd_dvd @ A @ ( times_times @ A @ C @ A2 ) @ ( times_times @ A @ C @ B ) )
          = ( ( C
              = ( zero_zero @ A ) )
            | ( dvd_dvd @ A @ A2 @ B ) ) ) ) ).

% dvd_mult_cancel_left
thf(fact_167_dvd__mult__cancel__right,axiom,
    ! [A: $tType] :
      ( ( idom @ A @ ( type @ A ) )
     => ! [A2: A,C: A,B: A] :
          ( ( dvd_dvd @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ C ) )
          = ( ( C
              = ( zero_zero @ A ) )
            | ( dvd_dvd @ A @ A2 @ B ) ) ) ) ).

% dvd_mult_cancel_right
thf(fact_168_dvd__times__left__cancel__iff,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( dvd_dvd @ A @ ( times_times @ A @ A2 @ B ) @ ( times_times @ A @ A2 @ C ) )
            = ( dvd_dvd @ A @ B @ C ) ) ) ) ).

% dvd_times_left_cancel_iff
thf(fact_169_dvd__times__right__cancel__iff,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( dvd_dvd @ A @ ( times_times @ A @ B @ A2 ) @ ( times_times @ A @ C @ A2 ) )
            = ( dvd_dvd @ A @ B @ C ) ) ) ) ).

% dvd_times_right_cancel_iff
thf(fact_170_unit__prod,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( dvd_dvd @ A @ A2 @ ( one_one @ A ) )
         => ( ( dvd_dvd @ A @ B @ ( one_one @ A ) )
           => ( dvd_dvd @ A @ ( times_times @ A @ A2 @ B ) @ ( one_one @ A ) ) ) ) ) ).

% unit_prod
thf(fact_171_dvd__div__mult__self,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( dvd_dvd @ A @ A2 @ B )
         => ( ( times_times @ A @ ( divide_divide @ A @ B @ A2 ) @ A2 )
            = B ) ) ) ).

% dvd_div_mult_self
thf(fact_172_dvd__mult__div__cancel,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( dvd_dvd @ A @ A2 @ B )
         => ( ( times_times @ A @ A2 @ ( divide_divide @ A @ B @ A2 ) )
            = B ) ) ) ).

% dvd_mult_div_cancel
thf(fact_173_unit__div__1__div__1,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( dvd_dvd @ A @ A2 @ ( one_one @ A ) )
         => ( ( divide_divide @ A @ ( one_one @ A ) @ ( divide_divide @ A @ ( one_one @ A ) @ A2 ) )
            = A2 ) ) ) ).

% unit_div_1_div_1
thf(fact_174_unit__div__1__unit,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( dvd_dvd @ A @ A2 @ ( one_one @ A ) )
         => ( dvd_dvd @ A @ ( divide_divide @ A @ ( one_one @ A ) @ A2 ) @ ( one_one @ A ) ) ) ) ).

% unit_div_1_unit
thf(fact_175_unit__div,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( dvd_dvd @ A @ A2 @ ( one_one @ A ) )
         => ( ( dvd_dvd @ A @ B @ ( one_one @ A ) )
           => ( dvd_dvd @ A @ ( divide_divide @ A @ A2 @ B ) @ ( one_one @ A ) ) ) ) ) ).

% unit_div
thf(fact_176_unit__mult__div__div,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( dvd_dvd @ A @ A2 @ ( one_one @ A ) )
         => ( ( times_times @ A @ B @ ( divide_divide @ A @ ( one_one @ A ) @ A2 ) )
            = ( divide_divide @ A @ B @ A2 ) ) ) ) ).

% unit_mult_div_div
thf(fact_177_unit__div__mult__self,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( dvd_dvd @ A @ A2 @ ( one_one @ A ) )
         => ( ( times_times @ A @ ( divide_divide @ A @ B @ A2 ) @ A2 )
            = B ) ) ) ).

% unit_div_mult_self
thf(fact_178_unit__factor__is__unit,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( dvd_dvd @ A @ ( normal627294541factor @ A @ A2 ) @ ( one_one @ A ) ) ) ) ).

% unit_factor_is_unit
thf(fact_179_is__unit__unit__factor,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( dvd_dvd @ A @ A2 @ ( one_one @ A ) )
         => ( ( normal627294541factor @ A @ A2 )
            = A2 ) ) ) ).

% is_unit_unit_factor
thf(fact_180_dvd__unit__factor__div,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [B: A,A2: A] :
          ( ( dvd_dvd @ A @ B @ A2 )
         => ( ( normal627294541factor @ A @ ( divide_divide @ A @ A2 @ B ) )
            = ( divide_divide @ A @ ( normal627294541factor @ A @ A2 ) @ ( normal627294541factor @ A @ B ) ) ) ) ) ).

% dvd_unit_factor_div
thf(fact_181_zdiv__int,axiom,
    ! [A2: nat,B: nat] :
      ( ( semiring_1_of_nat @ int @ ( divide_divide @ nat @ A2 @ B ) )
      = ( divide_divide @ int @ ( semiring_1_of_nat @ int @ A2 ) @ ( semiring_1_of_nat @ int @ B ) ) ) ).

% zdiv_int
thf(fact_182_Divides_Otransfer__int__nat__functions_I1_J,axiom,
    ! [X: nat,Y: nat] :
      ( ( divide_divide @ int @ ( semiring_1_of_nat @ int @ X ) @ ( semiring_1_of_nat @ int @ Y ) )
      = ( semiring_1_of_nat @ int @ ( divide_divide @ nat @ X @ Y ) ) ) ).

% Divides.transfer_int_nat_functions(1)
thf(fact_183_dvd__refl,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A @ ( type @ A ) )
     => ! [A2: A] : ( dvd_dvd @ A @ A2 @ A2 ) ) ).

% dvd_refl
thf(fact_184_dvd__trans,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( dvd_dvd @ A @ A2 @ B )
         => ( ( dvd_dvd @ A @ B @ C )
           => ( dvd_dvd @ A @ A2 @ C ) ) ) ) ).

% dvd_trans
thf(fact_185_of__bool__eq__iff,axiom,
    ! [A: $tType] :
      ( ( zero_neq_one @ A @ ( type @ A ) )
     => ! [P2: $o,Q: $o] :
          ( ( ( zero_neq_one_of_bool @ A @ P2 )
            = ( zero_neq_one_of_bool @ A @ Q ) )
          = ( P2 = Q ) ) ) ).

% of_bool_eq_iff
thf(fact_186_unit__factor__dvd,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( dvd_dvd @ A @ ( normal627294541factor @ A @ A2 ) @ B ) ) ) ).

% unit_factor_dvd
thf(fact_187_unit__factor__self,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A] : ( dvd_dvd @ A @ ( normal627294541factor @ A @ A2 ) @ A2 ) ) ).

% unit_factor_self
thf(fact_188_dvd__0__left,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( dvd_dvd @ A @ ( zero_zero @ A ) @ A2 )
         => ( A2
            = ( zero_zero @ A ) ) ) ) ).

% dvd_0_left
thf(fact_189_dvd__triv__right,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A @ ( type @ A ) )
     => ! [A2: A,B: A] : ( dvd_dvd @ A @ A2 @ ( times_times @ A @ B @ A2 ) ) ) ).

% dvd_triv_right
thf(fact_190_dvd__mult__right,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( dvd_dvd @ A @ ( times_times @ A @ A2 @ B ) @ C )
         => ( dvd_dvd @ A @ B @ C ) ) ) ).

% dvd_mult_right
thf(fact_191_mult__dvd__mono,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A,D: A] :
          ( ( dvd_dvd @ A @ A2 @ B )
         => ( ( dvd_dvd @ A @ C @ D )
           => ( dvd_dvd @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ D ) ) ) ) ) ).

% mult_dvd_mono
thf(fact_192_dvd__triv__left,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A @ ( type @ A ) )
     => ! [A2: A,B: A] : ( dvd_dvd @ A @ A2 @ ( times_times @ A @ A2 @ B ) ) ) ).

% dvd_triv_left
thf(fact_193_dvd__mult__left,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( dvd_dvd @ A @ ( times_times @ A @ A2 @ B ) @ C )
         => ( dvd_dvd @ A @ A2 @ C ) ) ) ).

% dvd_mult_left
thf(fact_194_dvd__mult2,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( dvd_dvd @ A @ A2 @ B )
         => ( dvd_dvd @ A @ A2 @ ( times_times @ A @ B @ C ) ) ) ) ).

% dvd_mult2
thf(fact_195_dvd__mult,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A @ ( type @ A ) )
     => ! [A2: A,C: A,B: A] :
          ( ( dvd_dvd @ A @ A2 @ C )
         => ( dvd_dvd @ A @ A2 @ ( times_times @ A @ B @ C ) ) ) ) ).

% dvd_mult
thf(fact_196_dvd__def,axiom,
    ! [A: $tType] :
      ( ( dvd @ A @ ( type @ A ) )
     => ( ( dvd_dvd @ A )
        = ( ^ [B2: A,A3: A] :
            ? [K2: A] :
              ( A3
              = ( times_times @ A @ B2 @ K2 ) ) ) ) ) ).

% dvd_def
thf(fact_197_dvdI,axiom,
    ! [A: $tType] :
      ( ( dvd @ A @ ( type @ A ) )
     => ! [A2: A,B: A,K: A] :
          ( ( A2
            = ( times_times @ A @ B @ K ) )
         => ( dvd_dvd @ A @ B @ A2 ) ) ) ).

% dvdI
thf(fact_198_dvdE,axiom,
    ! [A: $tType] :
      ( ( dvd @ A @ ( type @ A ) )
     => ! [B: A,A2: A] :
          ( ( dvd_dvd @ A @ B @ A2 )
         => ~ ! [K3: A] :
                ( A2
               != ( times_times @ A @ B @ K3 ) ) ) ) ).

% dvdE
thf(fact_199_one__dvd,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A @ ( type @ A ) )
     => ! [A2: A] : ( dvd_dvd @ A @ ( one_one @ A ) @ A2 ) ) ).

% one_dvd
thf(fact_200_unit__imp__dvd,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [B: A,A2: A] :
          ( ( dvd_dvd @ A @ B @ ( one_one @ A ) )
         => ( dvd_dvd @ A @ B @ A2 ) ) ) ).

% unit_imp_dvd
thf(fact_201_dvd__unit__imp__unit,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( dvd_dvd @ A @ A2 @ B )
         => ( ( dvd_dvd @ A @ B @ ( one_one @ A ) )
           => ( dvd_dvd @ A @ A2 @ ( one_one @ A ) ) ) ) ) ).

% dvd_unit_imp_unit
thf(fact_202_div__div__div__same,axiom,
    ! [A: $tType] :
      ( ( semiring_div @ A @ ( type @ A ) )
     => ! [D: A,A2: A,B: A] :
          ( ( dvd_dvd @ A @ D @ A2 )
         => ( ( dvd_dvd @ A @ D @ B )
           => ( ( dvd_dvd @ A @ B @ A2 )
             => ( ( divide_divide @ A @ ( divide_divide @ A @ A2 @ D ) @ ( divide_divide @ A @ B @ D ) )
                = ( divide_divide @ A @ A2 @ B ) ) ) ) ) ) ).

% div_div_div_same
thf(fact_203_unit__factor__mult,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( normal627294541factor @ A @ ( times_times @ A @ A2 @ B ) )
          = ( times_times @ A @ ( normal627294541factor @ A @ A2 ) @ ( normal627294541factor @ A @ B ) ) ) ) ).

% unit_factor_mult
thf(fact_204_unit__factor__nat__def,axiom,
    ( ( normal627294541factor @ nat )
    = ( ^ [N: nat] :
          ( if @ nat
          @ ( N
            = ( zero_zero @ nat ) )
          @ ( zero_zero @ nat )
          @ ( one_one @ nat ) ) ) ) ).

% unit_factor_nat_def
thf(fact_205_not__is__unit__0,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ~ ( dvd_dvd @ A @ ( zero_zero @ A ) @ ( one_one @ A ) ) ) ).

% not_is_unit_0
thf(fact_206_is__unit__mult__iff,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( dvd_dvd @ A @ ( times_times @ A @ A2 @ B ) @ ( one_one @ A ) )
          = ( ( dvd_dvd @ A @ A2 @ ( one_one @ A ) )
            & ( dvd_dvd @ A @ B @ ( one_one @ A ) ) ) ) ) ).

% is_unit_mult_iff
thf(fact_207_dvd__mult__unit__iff,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( dvd_dvd @ A @ B @ ( one_one @ A ) )
         => ( ( dvd_dvd @ A @ A2 @ ( times_times @ A @ C @ B ) )
            = ( dvd_dvd @ A @ A2 @ C ) ) ) ) ).

% dvd_mult_unit_iff
thf(fact_208_mult__unit__dvd__iff,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( dvd_dvd @ A @ B @ ( one_one @ A ) )
         => ( ( dvd_dvd @ A @ ( times_times @ A @ A2 @ B ) @ C )
            = ( dvd_dvd @ A @ A2 @ C ) ) ) ) ).

% mult_unit_dvd_iff
thf(fact_209_unit__mult__left__cancel,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( dvd_dvd @ A @ A2 @ ( one_one @ A ) )
         => ( ( ( times_times @ A @ A2 @ B )
              = ( times_times @ A @ A2 @ C ) )
            = ( B = C ) ) ) ) ).

% unit_mult_left_cancel
thf(fact_210_unit__mult__right__cancel,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( dvd_dvd @ A @ A2 @ ( one_one @ A ) )
         => ( ( ( times_times @ A @ B @ A2 )
              = ( times_times @ A @ C @ A2 ) )
            = ( B = C ) ) ) ) ).

% unit_mult_right_cancel
thf(fact_211_dvd__div__mult,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [C: A,B: A,A2: A] :
          ( ( dvd_dvd @ A @ C @ B )
         => ( ( times_times @ A @ ( divide_divide @ A @ B @ C ) @ A2 )
            = ( divide_divide @ A @ ( times_times @ A @ B @ A2 ) @ C ) ) ) ) ).

% dvd_div_mult
thf(fact_212_div__div__eq__right,axiom,
    ! [A: $tType] :
      ( ( semiring_div @ A @ ( type @ A ) )
     => ! [C: A,B: A,A2: A] :
          ( ( dvd_dvd @ A @ C @ B )
         => ( ( dvd_dvd @ A @ B @ A2 )
           => ( ( divide_divide @ A @ A2 @ ( divide_divide @ A @ B @ C ) )
              = ( times_times @ A @ ( divide_divide @ A @ A2 @ B ) @ C ) ) ) ) ) ).

% div_div_eq_right
thf(fact_213_div__mult__swap,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [C: A,B: A,A2: A] :
          ( ( dvd_dvd @ A @ C @ B )
         => ( ( times_times @ A @ A2 @ ( divide_divide @ A @ B @ C ) )
            = ( divide_divide @ A @ ( times_times @ A @ A2 @ B ) @ C ) ) ) ) ).

% div_mult_swap
thf(fact_214_dvd__div__mult2__eq,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [B: A,C: A,A2: A] :
          ( ( dvd_dvd @ A @ ( times_times @ A @ B @ C ) @ A2 )
         => ( ( divide_divide @ A @ A2 @ ( times_times @ A @ B @ C ) )
            = ( divide_divide @ A @ ( divide_divide @ A @ A2 @ B ) @ C ) ) ) ) ).

% dvd_div_mult2_eq
thf(fact_215_dvd__mult__imp__div,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,C: A,B: A] :
          ( ( dvd_dvd @ A @ ( times_times @ A @ A2 @ C ) @ B )
         => ( dvd_dvd @ A @ A2 @ ( divide_divide @ A @ B @ C ) ) ) ) ).

% dvd_mult_imp_div
thf(fact_216_div__mult__div__if__dvd,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [B: A,A2: A,D: A,C: A] :
          ( ( dvd_dvd @ A @ B @ A2 )
         => ( ( dvd_dvd @ A @ D @ C )
           => ( ( times_times @ A @ ( divide_divide @ A @ A2 @ B ) @ ( divide_divide @ A @ C @ D ) )
              = ( divide_divide @ A @ ( times_times @ A @ A2 @ C ) @ ( times_times @ A @ B @ D ) ) ) ) ) ) ).

% div_mult_div_if_dvd
thf(fact_217_dvd__div__unit__iff,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( dvd_dvd @ A @ B @ ( one_one @ A ) )
         => ( ( dvd_dvd @ A @ A2 @ ( divide_divide @ A @ C @ B ) )
            = ( dvd_dvd @ A @ A2 @ C ) ) ) ) ).

% dvd_div_unit_iff
thf(fact_218_div__unit__dvd__iff,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( dvd_dvd @ A @ B @ ( one_one @ A ) )
         => ( ( dvd_dvd @ A @ ( divide_divide @ A @ A2 @ B ) @ C )
            = ( dvd_dvd @ A @ A2 @ C ) ) ) ) ).

% div_unit_dvd_iff
thf(fact_219_unit__div__cancel,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( dvd_dvd @ A @ A2 @ ( one_one @ A ) )
         => ( ( ( divide_divide @ A @ B @ A2 )
              = ( divide_divide @ A @ C @ A2 ) )
            = ( B = C ) ) ) ) ).

% unit_div_cancel
thf(fact_220_unit__dvdE,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( dvd_dvd @ A @ A2 @ ( one_one @ A ) )
         => ~ ( ( A2
               != ( zero_zero @ A ) )
             => ! [C3: A] :
                  ( B
                 != ( times_times @ A @ A2 @ C3 ) ) ) ) ) ).

% unit_dvdE
thf(fact_221_dvd__div__eq__mult,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A,C: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( dvd_dvd @ A @ A2 @ B )
           => ( ( ( divide_divide @ A @ B @ A2 )
                = C )
              = ( B
                = ( times_times @ A @ C @ A2 ) ) ) ) ) ) ).

% dvd_div_eq_mult
thf(fact_222_div__dvd__iff__mult,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( B
           != ( zero_zero @ A ) )
         => ( ( dvd_dvd @ A @ B @ A2 )
           => ( ( dvd_dvd @ A @ ( divide_divide @ A @ A2 @ B ) @ C )
              = ( dvd_dvd @ A @ A2 @ ( times_times @ A @ C @ B ) ) ) ) ) ) ).

% div_dvd_iff_mult
thf(fact_223_dvd__div__iff__mult,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [C: A,B: A,A2: A] :
          ( ( C
           != ( zero_zero @ A ) )
         => ( ( dvd_dvd @ A @ C @ B )
           => ( ( dvd_dvd @ A @ A2 @ ( divide_divide @ A @ B @ C ) )
              = ( dvd_dvd @ A @ ( times_times @ A @ A2 @ C ) @ B ) ) ) ) ) ).

% dvd_div_iff_mult
thf(fact_224_dvd__div__div__eq__mult,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,C: A,B: A,D: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( C
             != ( zero_zero @ A ) )
           => ( ( dvd_dvd @ A @ A2 @ B )
             => ( ( dvd_dvd @ A @ C @ D )
               => ( ( ( divide_divide @ A @ B @ A2 )
                    = ( divide_divide @ A @ D @ C ) )
                  = ( ( times_times @ A @ B @ C )
                    = ( times_times @ A @ A2 @ D ) ) ) ) ) ) ) ) ).

% dvd_div_div_eq_mult
thf(fact_225_unit__eq__div1,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( dvd_dvd @ A @ B @ ( one_one @ A ) )
         => ( ( ( divide_divide @ A @ A2 @ B )
              = C )
            = ( A2
              = ( times_times @ A @ C @ B ) ) ) ) ) ).

% unit_eq_div1
thf(fact_226_unit__eq__div2,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( dvd_dvd @ A @ B @ ( one_one @ A ) )
         => ( ( A2
              = ( divide_divide @ A @ C @ B ) )
            = ( ( times_times @ A @ A2 @ B )
              = C ) ) ) ) ).

% unit_eq_div2
thf(fact_227_unit__div__commute,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [B: A,A2: A,C: A] :
          ( ( dvd_dvd @ A @ B @ ( one_one @ A ) )
         => ( ( times_times @ A @ ( divide_divide @ A @ A2 @ B ) @ C )
            = ( divide_divide @ A @ ( times_times @ A @ A2 @ C ) @ B ) ) ) ) ).

% unit_div_commute
thf(fact_228_unit__div__mult__swap,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [C: A,A2: A,B: A] :
          ( ( dvd_dvd @ A @ C @ ( one_one @ A ) )
         => ( ( times_times @ A @ A2 @ ( divide_divide @ A @ B @ C ) )
            = ( divide_divide @ A @ ( times_times @ A @ A2 @ B ) @ C ) ) ) ) ).

% unit_div_mult_swap
thf(fact_229_is__unit__div__mult2__eq,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [B: A,C: A,A2: A] :
          ( ( dvd_dvd @ A @ B @ ( one_one @ A ) )
         => ( ( dvd_dvd @ A @ C @ ( one_one @ A ) )
           => ( ( divide_divide @ A @ A2 @ ( times_times @ A @ B @ C ) )
              = ( divide_divide @ A @ ( divide_divide @ A @ A2 @ B ) @ C ) ) ) ) ) ).

% is_unit_div_mult2_eq
thf(fact_230_nat__mult__eq__cancel__disj,axiom,
    ! [K: nat,M: nat,N2: nat] :
      ( ( ( times_times @ nat @ K @ M )
        = ( times_times @ nat @ K @ N2 ) )
      = ( ( K
          = ( zero_zero @ nat ) )
        | ( M = N2 ) ) ) ).

% nat_mult_eq_cancel_disj
thf(fact_231_is__unitE,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,C: A] :
          ( ( dvd_dvd @ A @ A2 @ ( one_one @ A ) )
         => ~ ( ( A2
               != ( zero_zero @ A ) )
             => ! [B3: A] :
                  ( ( B3
                   != ( zero_zero @ A ) )
                 => ( ( dvd_dvd @ A @ B3 @ ( one_one @ A ) )
                   => ( ( ( divide_divide @ A @ ( one_one @ A ) @ A2 )
                        = B3 )
                     => ( ( ( divide_divide @ A @ ( one_one @ A ) @ B3 )
                          = A2 )
                       => ( ( ( times_times @ A @ A2 @ B3 )
                            = ( one_one @ A ) )
                         => ( ( divide_divide @ A @ C @ A2 )
                           != ( times_times @ A @ C @ B3 ) ) ) ) ) ) ) ) ) ) ).

% is_unitE
thf(fact_232_is__unit__divide__mult__cancel__left,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( dvd_dvd @ A @ B @ ( one_one @ A ) )
           => ( ( divide_divide @ A @ A2 @ ( times_times @ A @ A2 @ B ) )
              = ( divide_divide @ A @ ( one_one @ A ) @ B ) ) ) ) ) ).

% is_unit_divide_mult_cancel_left
thf(fact_233_normalize__div,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( divide_divide @ A @ ( normal1132893779malize @ A @ A2 ) @ A2 )
          = ( divide_divide @ A @ ( one_one @ A ) @ ( normal627294541factor @ A @ A2 ) ) ) ) ).

% normalize_div
thf(fact_234_normalize__unit__factor,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( normal1132893779malize @ A @ ( normal627294541factor @ A @ A2 ) )
            = ( one_one @ A ) ) ) ) ).

% normalize_unit_factor
thf(fact_235_unit__factor__normalize,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( normal627294541factor @ A @ ( normal1132893779malize @ A @ A2 ) )
            = ( one_one @ A ) ) ) ) ).

% unit_factor_normalize
thf(fact_236_normalize__idem,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( normal1132893779malize @ A @ ( normal1132893779malize @ A @ A2 ) )
          = ( normal1132893779malize @ A @ A2 ) ) ) ).

% normalize_idem
thf(fact_237_normalize__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( ( normal1132893779malize @ A @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% normalize_eq_0_iff
thf(fact_238_normalize__0,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ( ( normal1132893779malize @ A @ ( zero_zero @ A ) )
        = ( zero_zero @ A ) ) ) ).

% normalize_0
thf(fact_239_normalize__1,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ( ( normal1132893779malize @ A @ ( one_one @ A ) )
        = ( one_one @ A ) ) ) ).

% normalize_1
thf(fact_240_dvd__normalize__iff,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( dvd_dvd @ A @ A2 @ ( normal1132893779malize @ A @ B ) )
          = ( dvd_dvd @ A @ A2 @ B ) ) ) ).

% dvd_normalize_iff
thf(fact_241_normalize__dvd__iff,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( dvd_dvd @ A @ ( normal1132893779malize @ A @ A2 ) @ B )
          = ( dvd_dvd @ A @ A2 @ B ) ) ) ).

% normalize_dvd_iff
thf(fact_242_normalize__mult__unit__factor,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( normal1132893779malize @ A @ A2 ) @ ( normal627294541factor @ A @ A2 ) )
          = A2 ) ) ).

% normalize_mult_unit_factor
thf(fact_243_unit__factor__mult__normalize,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( normal627294541factor @ A @ A2 ) @ ( normal1132893779malize @ A @ A2 ) )
          = A2 ) ) ).

% unit_factor_mult_normalize
thf(fact_244_div__normalize,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( divide_divide @ A @ A2 @ ( normal1132893779malize @ A @ A2 ) )
          = ( normal627294541factor @ A @ A2 ) ) ) ).

% div_normalize
thf(fact_245_div__unit__factor,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( divide_divide @ A @ A2 @ ( normal627294541factor @ A @ A2 ) )
          = ( normal1132893779malize @ A @ A2 ) ) ) ).

% div_unit_factor
thf(fact_246_associatedI,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( dvd_dvd @ A @ A2 @ B )
         => ( ( dvd_dvd @ A @ B @ A2 )
           => ( ( normal1132893779malize @ A @ A2 )
              = ( normal1132893779malize @ A @ B ) ) ) ) ) ).

% associatedI
thf(fact_247_associatedD1,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( normal1132893779malize @ A @ A2 )
            = ( normal1132893779malize @ A @ B ) )
         => ( dvd_dvd @ A @ A2 @ B ) ) ) ).

% associatedD1
thf(fact_248_associatedD2,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( normal1132893779malize @ A @ A2 )
            = ( normal1132893779malize @ A @ B ) )
         => ( dvd_dvd @ A @ B @ A2 ) ) ) ).

% associatedD2
thf(fact_249_associated__eqI,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( dvd_dvd @ A @ A2 @ B )
         => ( ( dvd_dvd @ A @ B @ A2 )
           => ( ( ( normal1132893779malize @ A @ A2 )
                = A2 )
             => ( ( ( normal1132893779malize @ A @ B )
                  = B )
               => ( A2 = B ) ) ) ) ) ) ).

% associated_eqI
thf(fact_250_associated__iff__dvd,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( ( normal1132893779malize @ A @ A2 )
            = ( normal1132893779malize @ A @ B ) )
          = ( ( dvd_dvd @ A @ A2 @ B )
            & ( dvd_dvd @ A @ B @ A2 ) ) ) ) ).

% associated_iff_dvd
thf(fact_251_dvd__antisym,axiom,
    ! [M: nat,N2: nat] :
      ( ( dvd_dvd @ nat @ M @ N2 )
     => ( ( dvd_dvd @ nat @ N2 @ M )
       => ( M = N2 ) ) ) ).

% dvd_antisym
thf(fact_252_normalize__mult,axiom,
    ! [A: $tType] :
      ( ( normal1561407348emidom @ A @ ( type @ A ) )
     => ! [A2: A,B: A] :
          ( ( normal1132893779malize @ A @ ( times_times @ A @ A2 @ B ) )
          = ( times_times @ A @ ( normal1132893779malize @ A @ A2 ) @ ( normal1132893779malize @ A @ B ) ) ) ) ).

% normalize_mult

%----Type constructors (38)
thf(tcon_Int_Oint___Rings_Osemiring__no__zero__divisors__cancel,axiom,
    semiri1923998003cancel @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Osemiring__no__zero__divisors,axiom,
    semiri1193490041visors @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Oring__1__no__zero__divisors,axiom,
    ring_11004092258visors @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Onormalization__semidom,axiom,
    normal1561407348emidom @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Oalgebraic__semidom,axiom,
    algebraic_semidom @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1 @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Osemigroup__mult,axiom,
    semigroup_mult @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Osemidom__divide,axiom,
    semidom_divide @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Divides_Osemiring__div,axiom,
    semiring_div @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0 @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Ozero__neq__one,axiom,
    zero_neq_one @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Omonoid__mult,axiom,
    monoid_mult @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1 @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Ozero,axiom,
    zero @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Oidom,axiom,
    idom @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Oone,axiom,
    one @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Odvd,axiom,
    dvd @ int @ ( type @ int ) ).

thf(tcon_Nat_Onat___Rings_Osemiring__no__zero__divisors__cancel_1,axiom,
    semiri1923998003cancel @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Osemiring__no__zero__divisors_2,axiom,
    semiri1193490041visors @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Onormalization__semidom_3,axiom,
    normal1561407348emidom @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oab__semigroup__mult_4,axiom,
    ab_semigroup_mult @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Oalgebraic__semidom_5,axiom,
    algebraic_semidom @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocomm__monoid__mult_6,axiom,
    comm_monoid_mult @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__1_7,axiom,
    comm_semiring_1 @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Osemigroup__mult_8,axiom,
    semigroup_mult @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Osemidom__divide_9,axiom,
    semidom_divide @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Divides_Osemiring__div_10,axiom,
    semiring_div @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Nat_Osemiring__char__0_11,axiom,
    semiring_char_0 @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Ozero__neq__one_12,axiom,
    zero_neq_one @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Omonoid__mult_13,axiom,
    monoid_mult @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Osemiring__1_14,axiom,
    semiring_1 @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Omult__zero_15,axiom,
    mult_zero @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ozero_16,axiom,
    zero @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oone_17,axiom,
    one @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Odvd_18,axiom,
    dvd @ nat @ ( type @ nat ) ).

%----Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $false @ X @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $true @ X @ Y )
      = X ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    ( ( koenig1401075325scalar @ ( times_times @ nat @ n @ m ) @ xs )
    = ( koenig1401075325scalar @ n @ ( koenig1401075325scalar @ m @ xs ) ) ) ).

%------------------------------------------------------------------------------
